import { db } from "@/config/firebaseConfig";
import { collection, getDocs, query, where } from "firebase/firestore";
import { IGetProjects, IProject } from "@/interfaces/IProjects";

export async function getPProjectsService({ type }: IGetProjects) {
  console.log({ type });
  let querySnapshot;

  if (type === "Todos" || type == undefined) {
    querySnapshot = await getDocs(query(collection(db, "projects")));
  } else {
    const projectsRef = collection(db, "projects");
    const q = query(projectsRef, where("type", "==", type));
    querySnapshot = await getDocs(q);
  }

  const projects: IProject[] = [];
  querySnapshot.forEach((doc) => {
    const publication = {
      ...doc.data(),
      id: doc.id,
    } as IProject;
    projects.push(publication);
  });

  return projects;
}
