import { db } from "@/config/firebaseConfig";
import { collection, getDocs } from "firebase/firestore";

import { IAlbumsGalleryPhotos } from "@/interfaces/IAlbumsGalleryPhotos";

export async function getNamesAlbumsService() {
  const querySnapshot = await getDocs(collection(db, "albums_image"));
  const albums: IAlbumsGalleryPhotos[] = [];

  querySnapshot.forEach((doc) => {
    const dataValue = {
      ...doc.data(),
      id: doc.id,
    } as IAlbumsGalleryPhotos;

    albums.push(dataValue);
  });

  return albums;
}
