import { queryClient } from "@/config/queryClient";
import { IGetPublication } from "@/interfaces/IPublications";
import { ITeacher } from "@/interfaces/ITeacher";
import { getTPublicationsService } from "@/services/getPublications.service";

import { useQuery } from "@tanstack/react-query";

export function useGetPublications({ teacherId }: IGetPublication) {
  return useQuery({
    queryKey: ["publications", teacherId],
    queryFn: () =>
      getTPublicationsService({ teacherId: getIdTeacher({ teacherId }) }),
  });
}

function getIdTeacher({ teacherId }: IGetPublication) {
  const teachers = queryClient.getQueryData<ITeacher[]>(["teachers"]);

  if (teachers) {
    if (teacherId === "Todos") {
      return "Todos";
    }

    const teacher = teachers.find((teacher) => teacher.name === teacherId);
    return teacher?.id;
  }
  return undefined;
}
