import { IGetProjects } from "@/interfaces/IProjects";
import { getPProjectsService } from "@/services/getProjects.service";

import { useQuery } from "@tanstack/react-query";

export function useGetProjects({ type }: IGetProjects) {
  return useQuery({
    queryKey: ["projects", type],
    queryFn: () => getPProjectsService({ type }),
  });
}
