import { IGetPhotoGallery } from "@/interfaces/IPhotoGallery";
import { getPhotoGalleryService } from "@/services/getPhotoGallery.service";
import { useQuery } from "@tanstack/react-query";

export function useGetPhotoGallery({ albumId, type }: IGetPhotoGallery) {
  return useQuery({
    queryKey: ["photoGallery", albumId, type],
    queryFn: () => getPhotoGalleryService({ albumId }),
  });
}
