import { Button } from "../ui/button";
import { SectionId } from "@/constants/sectionIds";
import { getImagePath } from "@/lib/getImagePath";
import Link from "next/link";

export function PublicationsSection() {
  return (
    <div
      id={SectionId.PUBLICATIONS}
      className="relative w-full h-auto bg-cover bg-center mb-96 sm:mb-0"
    >
      <div className="relative w-full h-full bg-cover bg-center pt-32">
        <h1 className="relative text-3xl font-bold text-black text-center z-10">
          Publicações
        </h1>
        <div className="flex max-w-screen-2xl mx-auto w-full items-center justify-between gap-4 p-0 sm:p-10 flex-col md:flex-row ">
          <div className=" w-[100%] md:w-[30%] lg:w-[40%] flex flex-row items-center justify-center md:justify-end">
            <img
              src={getImagePath("/assets/sectionGallery.png")}
              alt="Imagem ilustrativa"
              width={300}
              height={300}
              className="w-[100%]: lg:w-[60%] h-auto object-cover"
            />
          </div>

          <div className="w-full md:w-[70%] lg:w-[60%] flex relative ">
            <img
              src={getImagePath("/assets/bgGallery.svg")}
              alt="Imagem ilustrativa"
              width={300}
              height={300}
              className="hidden sm:block w-full sm:w-[650px] h-auto object-cover"
            />
            <div
              className={`absolute mb-10 w-full sm:w-[80%] pl-14 flex flex-col items-center lg:w-[68%] pt-10 lg:pt-7 bg-[url('${getImagePath(
                "/assets/bgGallery.svg"
              )}')] sm:bg-none bg-cover bg-center`}
            >
              <p className="text-white font-normal mb-9 pr-14 sm:pr-0  ">
                Aqui você encontrará informações sobre artigos e pesquisas
                publicados por nossos professores e alunos, destacando o talento
                e a dedicação da nossa comunidade acadêmica. Este espaço é
                dedicado a compartilhar conhecimento e inspirar em novas ideias.
                <br /> <br />
                Explore as contribuições científicas, acompanhe os avanços em
                diversas áreas do saber e valorize o trabalho intelectual que
                enriquece nosso ambiente de aprendizado e inovação.
                <br /> <br />
                “Publicar é transformar conhecimento em impacto. Junte-se a nós
                nessa jornada!”
              </p>
              <Link
                href="/publications"
                passHref
                className="w-full sm:w-auto -ml-14 flex justify-center"
              >
                <Button variant={"secondary"}>Saiba mais</Button>
              </Link>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
}
