"use client";

import {
  Table,
  TableBody,
  TableCaption,
  TableCell,
  TableHead,
  TableHeader,
  TableRow,
} from "@/components/ui/table";
import {
  Select,
  SelectContent,
  SelectItem,
  SelectTrigger,
  SelectValue,
} from "@/components/ui/select";

import { useGetTeachers } from "@/hooks/useGetTeachers";
import { useGetPublications } from "@/hooks/useGetPublications";
import { useState } from "react";
import { DialogInfoTeacher } from "./dialogInfoTeacher";
import { queryClient } from "@/config/queryClient";
import { ITeacher } from "@/interfaces/ITeacher";

export function PublicationsHome() {
  const query = useGetTeachers();
  const [filterTeacher, setFilterTeacher] = useState<"Todos" | string>("Todos");
  const queryPublications = useGetPublications({ teacherId: filterTeacher });

  const [teacherSelect, setTeacherSelect] = useState({} as ITeacher);

  if (query.isLoading) {
    return (
      <div className="max-w-screen-2xl mx-auto pt-40">
        <div className="flex flex-row justify-center items-center mb-9">
          <p>Carregando...</p>
        </div>
      </div>
    );
  }

  function onTeacherSelect(teacherSelected: string) {
    const teachers = queryClient.getQueryData<ITeacher[]>(["teachers"]);
    let valueTeacherSelected = teacherSelected;

    if (teachers) {
      const teacher = teachers.find(
        (teacher) => teacher.name === teacherSelected
      );
      valueTeacherSelected = teacher?.id as string;
      setTeacherSelect(teacher as ITeacher);
    }

    setFilterTeacher(valueTeacherSelected);
  }

  return (
    <div className="max-w-screen-2xl mx-auto pt-40">
      <div className="flex flex-row justify-between items-center mb-9">
        <div className="flex flex-row justify-between items-center">
          <p className="mr-2 font-medium">Selecione um professor:</p>
          <Select onValueChange={onTeacherSelect}>
            <SelectTrigger className="w-auto">
              <SelectValue placeholder="Todos" />
            </SelectTrigger>
            <SelectContent>
              <SelectItem value="Todos">Todos</SelectItem>

              {query.data?.map((teacher) => (
                <SelectItem key={teacher.id} value={teacher.name}>
                  {teacher.name}
                </SelectItem>
              ))}
            </SelectContent>
          </Select>
        </div>
        {filterTeacher !== "Todos" && (
          <DialogInfoTeacher data={teacherSelect} />
        )}
      </div>
      <Table className="border border-gray-300">
        <TableHeader>
          <TableRow className="border border-gray-300">
            <TableHead className="text-center text-black font-semibold border border-gray-300">
              Nome do Autor
            </TableHead>
            <TableHead className="text-center text-black font-semibold border border-gray-300">
              Título do Artigo
            </TableHead>
            <TableHead className="text-center text-black font-semibold border border-gray-300">
              Ano de Publicação
            </TableHead>
            <TableHead className="text-center text-black font-semibold border border-gray-300">
              Revista/Evento
            </TableHead>
            <TableHead className="text-center text-black font-semibold border border-gray-300">
              DOI/link
            </TableHead>
          </TableRow>
        </TableHeader>
        {queryPublications.data !== undefined &&
        queryPublications.data?.length > 0 ? (
          queryPublications.data?.map((publication) => (
            <TableBody key={publication.id}>
              <TableRow className="border border-gray-300">
                <TableCell className="text-center border border-gray-300">
                  {publication.authorName}
                </TableCell>
                <TableCell className="text-center border border-gray-300">
                  {publication.title}
                </TableCell>
                <TableCell className="text-center border border-gray-300">
                  {publication.yearOfPublication}
                </TableCell>
                <TableCell className="text-center border border-gray-300">
                  {publication.magazineEvent}
                </TableCell>
                <TableCell className="text-center border border-gray-300">
                  {publication.doiLink}
                </TableCell>
              </TableRow>
            </TableBody>
          ))
        ) : (
          <TableCaption>Sem dados a serem exibidos</TableCaption>
        )}
      </Table>
    </div>
  );
}
