import { SectionId } from "@/constants/sectionIds";
import { CardItems } from "./cardItems";
import { getImagePath } from "@/lib/getImagePath";

export function ProjectsSection() {
  return (
    <div
      id={SectionId.PROJECTS}
      className="relative w-full h-auto bg-cover pt-10 mb-20 sm:mb-12"
    >
      <div className="relative w-full h-full bg-cover pt-14 pb-14">
        <img
          src={getImagePath("/assets/bgRight.svg")}
          alt="Background"
          className="absolute right-0 top-0 w-[630px] object-cover z-0"
        />
        <h1 className="relative text-3xl font-bold text-black text-center z-10">
          Projetos
        </h1>
        <div className="relative flex max-w-screen-2xl mx-auto w-full gap-10 items-stretch justify-center pl-5 pr-5 pt-14 flex-wrap sm:flex-nowrap z-10">
          <CardItems
            title="Ensino"
            text="Referem-se às tarefas direcionadas ao desenvolvimento dos estudantes, incluindo sessões teóricas e práticas, funções de monitoria, entre outras."
            backgroundImage={getImagePath("/assets/bgImageCard.png")}
            hrefLink="/projects/ensino"
          />

          <CardItems
            title="Pesquisa"
            text="Refere-se às iniciativas realizadas com o propósito de promover atividades de pesquisa, incluindo a participação em projetos como PIBIC, TCC, entre outros."
            backgroundImage={getImagePath("/assets/bgImageCard.png")}
            hrefLink="/projects/pesquisa"
          />

          <CardItems
            title="Extensão"
            text="Relacionam-se às ações em que toda a comunidade acadêmica disseminam seu saber para o público em geral, por meio de iniciativas como o PACE, PIBEX, entre outras."
            backgroundImage={getImagePath("/assets/bgImageCard.png")}
            hrefLink="/projects/extensao"
          />
        </div>
      </div>
    </div>
  );
}
