"use client";

import { SectionId } from "@/constants/sectionIds";

import { useEffect, useState } from "react";
import { usePathname } from "next/navigation";
import { useRouter } from "next/navigation";
import Link from "next/link";
import { getImagePath } from "@/lib/getImagePath";
import { getBasePath } from "@/lib/getBasePath";

export function Navbar() {
  const pathname = usePathname();
  const router = useRouter();
  const [isOpen, setIsOpen] = useState(false);
  const [sectionId, setSectionId] = useState<SectionId>("inicio");

  const getLinkClass = (path: SectionId) => {
    return `${
      sectionId === path ? "font-semibold" : "font-normal"
    } text-xl text-primary`;
  };

  const scrollToSection = (id: SectionId) => {
    setSectionId(id);
    const element = document.getElementById(id);
    if (element) {
      element.scrollIntoView({ behavior: "smooth" });
    }
    setIsOpen(false);
  };

  const toggleMenu = () => {
    setIsOpen(!isOpen);
  };

  function navigationPage() {
    if (pathname === "/galery") {
      router.push(getBasePath());
    }

    if (pathname === "/courses") {
      router.push(getBasePath());
    }
    if (pathname === "/publications") {
      router.push(getBasePath());
    }

    scrollToSection("inicio");
    setSectionId("inicio");
  }

  useEffect(() => {
    if (pathname === "/galery") {
      scrollToSection("gallery");
      setSectionId("gallery");
    }
    if (pathname === "/courses") {
      scrollToSection("courses");
      setSectionId("courses");
    }
    if (pathname === "/publications") {
      scrollToSection("publications");
      setSectionId("publications");
    }
  }, [pathname]);

  return (
    <div
      className={`fixed top-0 left-0 w-full z-50 shadow-lg bg-gradient-to-r from-[#033B93] to-[#007AFF]   `}
    >
      <div className="max-w-screen-2xl mx-auto flex w-full items-center justify-between flex-wrap gap-4 pl-10 pr-10">
        <div className="flex items-center gap-4">
          <Link href={getBasePath()}>
            <img
              src={getImagePath("/assets/LOGAR_v1-no-bg.png")}
              className="mr-2"
              alt={"Logo"}
              width={160}
              height={10}
            />
          </Link>
        </div>

        <div className="lg:hidden">
          <button
            onClick={toggleMenu}
            className="text-primary focus:outline-none"
          >
            <svg
              className="w-8 h-8"
              fill="none"
              stroke="currentColor"
              viewBox="0 0 24 24"
              xmlns="http://www.w3.org/2000/svg"
            >
              <path
                strokeLinecap="round"
                strokeLinejoin="round"
                strokeWidth={2}
                d={isOpen ? "M6 18L18 6M6 6l12 12" : "M4 6h16M4 12h16M4 18h16"}
              />
            </svg>
          </button>
        </div>

        <nav
          className={`${
            isOpen ? "flex" : "hidden"
          } lg:flex flex-row w-full lg:w-auto bg-white rounded-[20px] py-[30px] lg:py-[5px] px-[30px]`}
        >
          <ul className="flex flex-col lg:flex-row gap-8">
            <li>
              <button
                className={getLinkClass("inicio")}
                onClick={() => navigationPage()}
              >
                Início
              </button>
            </li>
            {pathname == "/" && (
              <li>
                <button
                  className={getLinkClass("lab313")}
                  onClick={() => scrollToSection("lab313")}
                >
                  Logar
                </button>
              </li>
            )}

            {pathname == "/" && (
              <li>
                <button
                  className={getLinkClass("projects")}
                  onClick={() => scrollToSection("projects")}
                >
                  Projetos
                </button>
              </li>
            )}

            {pathname == "/" || pathname === "/publications" ? (
              <li>
                <button
                  className={getLinkClass("publications")}
                  onClick={() => scrollToSection("publications")}
                >
                  Publicações
                </button>
              </li>
            ) : null}

            {pathname == "/" || pathname === "/courses" ? (
              <li>
                <button
                  className={getLinkClass("courses")}
                  onClick={() => scrollToSection("courses")}
                >
                  Cursos
                </button>
              </li>
            ) : null}

            {pathname === "/" || pathname === "/gallery" ? (
              <li>
                <button
                  className={getLinkClass("gallery")}
                  onClick={() => scrollToSection("gallery")}
                >
                  Galeria
                </button>
              </li>
            ) : null}

            {pathname == "/" && (
              <li>
                <button
                  className={getLinkClass("teachers")}
                  onClick={() => scrollToSection("teachers")}
                >
                  Docentes
                </button>
              </li>
            )}

            <li>
              <button
                className={getLinkClass("contact")}
                onClick={() => scrollToSection("contact")}
              >
                Contato
              </button>
            </li>
          </ul>
        </nav>
      </div>
    </div>
  );
}
