import { SectionId } from "@/constants/sectionIds";
import { CardItems } from "./cardItems";
import { getImagePath } from "@/lib/getImagePath";

export function Lab313Section() {
  return (
    <div id={SectionId.LAB313} className="relative w-full h-auto ">
      <div className="relative w-full h-full bg-cover pt-14 pb-14">
        <div className="flex max-w-screen-2xl mx-auto w-full items-stretch pl-5 pr-5 pt-14 flex-wrap flex-col lg:flex-row">
          <div className="w-full lg:w-[40%] flex justify-center lg:justify-end z-10 relative ">
            <h1 className="text-3xl font-bold text-black z-10 absolute w-full text-center top-12">
              LOGAR
            </h1>
            <img
              src={getImagePath("assets/sectionLab313Left.png")}
              alt="Left Image"
              className="w-[45%] lg:w-[75%] object-cover mt-28 pr-4 hidden lg:block"
            />
          </div>

          <div className="w-full lg:w-[690px] max-1187:w-[790px] flex -ml-0 lg:-ml-28 pb-0 relative lg:pr-36">
            <img
              src={getImagePath("assets/bgGallery.svg")}
              alt="Background Image"
              className="absolute inset-0 w-full lg:h-[550px] z-0 lg:pr-36 hidden lg:block"
            />

            <div className="relative z-10 p-5 lg:pt-[100px] max-1187:pt-[70px] lg:pl-[124px] lg:pr-14 flex flex-col sm:flex-row items-center lg:block ">
              <img
                src={getImagePath("assets/sectionLab313Left.png")}
                alt="Left Image"
                className="w-[55%] sm:w-[45%] lg:w-[75%] object-cover mt-28 pr-4 lg:hidden "
              />
              <p className="text-black lg:text-white text-center sm:text-start">
                {`O Laboratório de Pesquisa em Computação I (LabComp I), também
                conhecido como #LOGAR, tem como missão estudar e desenvolver
                produtos tecnológicos de alta qualidade, empregando boas
                práticas de programação, além de contribuir para o avanço
                científico na área de computação, preparando os alunos para o
                mercado de trabalho. Além disso, busca incentivar e consolidar a
                participação feminina na computação por meio do programa "Ei
                Mana: Meninas na Computação".`}
              </p>
            </div>
          </div>
        </div>

        <div className="flex max-w-screen-2xl mx-auto w-full items-stretch pl-5 pr-5 lg:-mt-[140px] flex-wrap flex-col lg:flex-row">
          <div className="w-full lg:w-[60%] flex -ml-0 lg:-ml-28 pb-0 relative lg:pl-52 justify-end">
            <img
              src={getImagePath("assets/bgGallery.svg")}
              alt="Background Image"
              className="absolute inset-0 lg:left-56 w-full lg:h-[550px] z-0 hidden lg:block lg:max-w-[800px]"
            />

            <div className="relative z-10 p-5  max-1187:pt-[70px] lg:pl-[60px] max-1187:pl-[124px] lg:pr-8  max-1187:pr-14 w-full lg:w-auto flex items-center flex-col lg:block bg-cover bg-center h-auto sm:flex-row">
              <img
                src={getImagePath("assets/sectionLab313Right.png")}
                alt="Left Image"
                className="lg:w-[75%] w-[55%] sm:w-[45%] object-contain pr-4 lg:hidden"
              />
              <p className="text-black lg:text-white lg:mt-28 max-1187:mt-20 text-center sm:text-start ">
                {`Entre suas principais áreas de foco estão:
                Engenharia de Software, Interação Humano-Computador, 
                Sistemas Embarcados e Internet das Coisas, Robótica e Visão Computacional,
                Inteligência Artificial, Informática na Educação, Gestão da Informação, 
                Programação Web e Android, Pesquisa Operacional e Otimização.`}
              </p>
            </div>
          </div>

          <div className="hidden w-full lg:w-[40%] lg:flex justify-start z-10 max-1187:-mt-64 lg:-mt-28">
            <img
              src={getImagePath("assets/sectionLab313Right.png")}
              alt="Left Image"
              className="w-[75%] object-contain pr-4"
            />
          </div>
        </div>

        <div className="relative flex max-w-screen-2xl mx-auto w-full gap-10 items-stretch justify-center pl-5 pr-5 pt-14 flex-wrap sm:flex-nowrap z-10">
          <CardItems
            title="Missão"
            text="Conduzir pesquisas inovadoras em computação, desenvolvendo soluções tecnológicas que impactem positivamente a sociedade, promovendo a colaboração entre academia, indústria e comunidade."
            backgroundImage={getImagePath("assets/bgImageCard.png")}
          />

          <CardItems
            title="Visão"
            text="Ser uma referência na região norte através do ensino, da pesquisa, da extensão e do desenvolvimento de produtos tecnológicos"
            backgroundImage={getImagePath("assets/bgImageCard.png")}
          />

          <CardItems
            title="Valores"
            text={[
              "Inovação contínua e excelência técnica",
              "Colaboração e interdisciplinaridade;",
              "Compromisso com a ética e responsabilidade social;",
              "Valorização do conhecimento e educação;",
              "Respeito à diversidade e inclusão.",
            ]}
            backgroundImage={getImagePath("assets/bgImageCard.png")}
          />
        </div>
      </div>
    </div>
  );
}
