import { SectionId } from "@/constants/sectionIds";
import { getImagePath } from "@/lib/getImagePath";

export function HomeSection() {
  return (
    <div
      id={SectionId.INICIO}
      className="relative w-full h-auto bg-cover bg-center"
    >
      <div
        className="relative w-full h-full bg-cover bg-center"
        style={{
          backgroundImage: `url('${getImagePath("assets/bgInicio.svg")}`,
        }}
      >
        <div className="flex max-w-screen-2xl mx-auto w-full items-center justify-between gap-4 p-10 pt-40">
          <div className="w-full md:w-1/2 flex flex-col items-center justify-center md:items-start md:justify-start ">
            <div className="w-2/3 flex justify-center md:hidden mb-4 ">
              <img
                src={getImagePath("assets/imageInicio.png")}
                alt="Imagem ilustrativa"
                width={300}
                height={300}
                className="w-[95%] h-auto object-cover"
              />
            </div>

            <h1 className="text-white text-4xl md:text-5xl lg:text-6xl font-bold mb-10">
              Bem - Vindos ao LOGAR
            </h1>

            <p className="text-white text-xl md:text-2xl lg:text-3xl font-semibold mb-9">
              Laboratório de Computação em Otimização, Gestão, Análise e
              Robótica
            </p>

            <p className="text-white text-lg md:text-xl lg:text-2xl font-normal mb-10">
              Localizado na Instituição de Ciências Exatas e Tecnologia -
              ICET/UFAM, o laboratório é especializado em pesquisa e
              desenvolvimento, atuando em diversas áreas da computação.
            </p>
          </div>

          <div className="w-1/2  justify-center hidden md:flex">
            <img
              src={getImagePath("assets/imageInicio.png")}
              alt="Imagem ilustrativa"
              width={300}
              height={300}
              className="w-[95%] h-auto object-cover"
            />
          </div>
        </div>
      </div>
    </div>
  );
}
