import React from "react";

interface FormOfEntryProps {
  text: string | string[];
  type: "PSC" | "SISU" | "PSI";
}

export function FormOfEntry({ type, text }: FormOfEntryProps) {
  return (
    <div className="flex flex-col items-center rounded-[20px] border border-cyan-700 p-5 max-w-[290px] ">
      <p className="text-4xl font-bold pb-2">{type}</p>
      <p className="text-justify">{text}</p>
      {type === "PSC" && <ImageFormOfEntry image="/assets/psc.png" />}
      {type === "SISU" && (
        <>
          <ImageFormOfEntry image="/assets/enem.png" />
          <ImageFormOfEntry image="/assets/sisu.png" />
        </>
      )}
      {type === "PSI" && <ImageFormOfEntry image="/assets/psi.png" />}
    </div>
  );
}

function ImageFormOfEntry({ image }: { image: string }) {
  return <img alt="Image " src={image} className=" object-cover w-[120px]" />;
}
