import Image from "next/image";
import { Button } from "@/components/ui/button";
import {
  Dialog,
  DialogContent,
  DialogDescription,
  DialogTitle,
  DialogTrigger,
} from "@/components/ui/dialog";

import { Label } from "@/components/ui/label";
import { ITeacher } from "@/interfaces/ITeacher";
import Link from "next/link";
import { getImagePath } from "@/lib/getImagePath";

interface IDialogInfoTeacherProps {
  data: ITeacher;
  typeScreen?: "home" | "publications";
}

export function DialogInfoTeacher({
  data,
  typeScreen = "publications",
}: IDialogInfoTeacherProps) {
  return (
    <Dialog>
      <DialogTrigger asChild>
        {typeScreen === "publications" ? (
          <Button variant="outline" className="h-auto">
            Informações do professor
            <Image
              src={data.image}
              alt={data.name}
              width={50}
              height={50}
              className="rounded-full h-[50px] ml-2 object-cover border border-gray-300"
            />
          </Button>
        ) : (
          <Button variant={"secondary"} className="h-auto">
            <div className="flex flex-col items-center text-center">
              <img
                src={getImagePath(data.avatar)}
                alt={data.name}
                className="w-36 h-36 rounded-full object-cover shadow-md border border-black"
              />
              <span className="mt-2 text-lg font-medium text-black">
                {data.firstAndLastName}
              </span>
            </div>
          </Button>
        )}
      </DialogTrigger>
      <DialogContent className="sm:max-w-md">
        <div className="w-full flex flex-col items-center mb-4">
          <Image
            src={data.image}
            alt={data.name}
            width={191}
            height={191}
            className="rounded-full h-[191px] ml-2 object-cover border border-gray-300 mb-2"
          />

          <DialogTitle>{data.name}</DialogTitle>
        </div>

        <div className="flex flex-col gap-3">
          <div>
            <Label>Formação acadêmica/titulação:</Label>
            <DialogDescription>
              {data.academicBackgroundAndQualification}
            </DialogDescription>
          </div>

          <div>
            <Label>Nome em citações bibliográficas:</Label>
            <DialogDescription>
              {data.nameInBibliographicCitations}
            </DialogDescription>
          </div>
          <div>
            <Label>País de Nacionalidade:</Label>
            <DialogDescription>{data.countryOfNationality}</DialogDescription>
          </div>

          <div>
            <Label>ID Lattes:</Label>
            <DialogDescription>{data.IDLattes}</DialogDescription>
          </div>

          <div>
            <Label>Currículo Lattes:</Label>
            <DialogDescription>
              <Link href={data.cv} target="_blank">
                {data.cv}
              </Link>
            </DialogDescription>
          </div>
        </div>
      </DialogContent>
    </Dialog>
  );
}
