import Link from "next/link";
import React from "react";
import { Button } from "../ui/button";

interface CardItemsProps {
  title: string;
  text: string | string[];
  backgroundImage: string;
  hrefLink?: string;
}

export function CardItems({
  title,
  text,
  backgroundImage,
  hrefLink,
}: CardItemsProps) {
  const isArray = Array.isArray(text);

  return (
    <div
      className="relative w-[290px] rounded-lg overflow-hidden shadow-lg"
      style={{
        backgroundImage: `url(${backgroundImage})`,
        backgroundSize: "cover",
        backgroundPosition: "center",
      }}
    >
      <div className="h-full inset-0 bg-black bg-opacity-80 flex flex-col">
        <div className="relative z-10 p-6 text-white flex flex-col flex-grow">
          <h2 className="text-2xl font-semibold mb-2 text-center">{title}</h2>
          {isArray ? (
            <ul className="list-disc pl-5">
              {text.map((line, index) => (
                <li key={index}>{line}</li>
              ))}
            </ul>
          ) : (
            <p className="text-base text-justify">{text}</p>
          )}

          {hrefLink ? (
            <div className="mt-auto flex justify-center pt-4">
              <Link href={hrefLink} passHref>
                <Button variant={"secondary"}>Ver projetos</Button>
              </Link>
            </div>
          ) : null}
        </div>
      </div>
    </div>
  );
}
