import type { Metadata } from "next";
import "./globals.css";
import { cn } from "@/lib/utils";
import { Navbar } from "@/components/organism/navbar";
import { Footer } from "@/components/organism/footer";
import "react-photo-album/styles.css";
import "react-photo-album/masonry.css";
import "photoswipe/dist/photoswipe.css";

import Providers from "./providers";

export const metadata: Metadata = {
  title: "Logar",
  description: "Laboratório de Pesquisa em Computação I (LabComp I)",
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="pt">
      <head>
        <link
          rel="stylesheet"
          href="https://fonts.googleapis.com/css2?family=Inter&display=swap"
        />
      </head>
      <body
        className={cn(
          "flex min-h-screen bg-white font-sans antialiased flex-col justify-between"
        )}
      >
        <Providers>
          <Navbar />
          {children}
          <Footer />
        </Providers>
      </body>
    </html>
  );
}
