"use client";

import { MasonryPhotoAlbum } from "react-photo-album";

import { Gallery, Item } from "react-photoswipe-gallery";

import "react-photo-album/styles.css";
import "react-photo-album/masonry.css";
import "photoswipe/dist/photoswipe.css";

import usePhotos from "./photos";
import { useRouter } from "next/navigation";
import {
  Select,
  SelectContent,
  SelectItem,
  SelectTrigger,
  SelectValue,
} from "@/components/ui/select";
import { useState } from "react";
import { Button } from "@/components/ui/button";
import { useGetNamesAlbums } from "@/hooks/useGetNamesAlbums";
import Image from "next/image";

const dataFilterGallery = [
  { id: "1", name: "Todos" },
  { id: "2", name: "Álbums" },
];

export default function App() {
  const router = useRouter();
  const photos = usePhotos({ type: "Todos" });

  const dataAlbumsNames = useGetNamesAlbums();

  const [typeNameFilterSelect, setTypeNameFilterSelect] =
    useState<string>("Todos");

  function onFilterTypeSelect(typeSelected: string) {
    setTypeNameFilterSelect(typeSelected);
  }

  return (
    <div className="relative w-full h-auto bg-cover bg-center">
      <div className="max-w-screen-2xl mx-auto pt-40">
        <div className="flex flex-row items-center mb-9">
          <p className="mr-2 font-medium">Selecione uma opção:</p>
          <Select onValueChange={onFilterTypeSelect}>
            <SelectTrigger className="w-auto">
              <SelectValue placeholder="Todos" />
            </SelectTrigger>
            <SelectContent>
              {dataFilterGallery.map((item) => (
                <SelectItem key={item.id} value={item.name}>
                  {item.name}
                </SelectItem>
              ))}
            </SelectContent>
          </Select>
        </div>

        {typeNameFilterSelect === "Todos" ? (
          <>
            {!photos.isLoading && photos.photos.length > 0 ? (
              <Gallery>
                <MasonryPhotoAlbum
                  photos={photos.photos}
                  spacing={5}
                  render={{
                    photo: ({}, { photo }) => (
                      <Item
                        content={
                          <div className="flex items-center justify-center w-screen h-screen">
                            <Image
                              key={photo.key}
                              src={photo.src}
                              alt={photo.src}
                              width={photo.width}
                              height={photo.height}
                              className="object-contain w-full h-full"
                            />
                          </div>
                        }
                      >
                        {({ ref, open }) => (
                          <div className="flex items-center justify-center">
                            <Image
                              key={photo.key}
                              ref={ref}
                              onClick={open}
                              alt={photo.src}
                              src={photo.src}
                              width={photo.width}
                              height={photo.height}
                              className="object-contain"
                            />
                          </div>
                        )}
                      </Item>
                    ),
                  }}
                />
              </Gallery>
            ) : (
              <div className="flex items-center justify-center flex-1 w-full h-full mt-9">
                <p className="text-lg font-medium">Carregando imagens</p>
              </div>
            )}
          </>
        ) : (
          <div className="flex flex-1 w-full flex-wrap h-full">
            {dataAlbumsNames.data && dataAlbumsNames.data.length > 0 ? (
              <>
                {dataAlbumsNames.data.map((itemAlbum) => (
                  <Button
                    key={itemAlbum.id}
                    variant="ghost"
                    className="h-auto p-2 rounded-[10px] flex-col items-start gap-2 justify-start"
                    onClick={() => router.push(`/album?slug=${itemAlbum.id}`)}
                  >
                    <div className="w-[150px] h-[190px]">
                      <Image
                        src={itemAlbum.thumbnail}
                        alt={itemAlbum.name}
                        width={150}
                        height={150}
                        className="object-cover rounded-[10px] w-full h-full"
                      />
                    </div>

                    <p className="w-[150px] break-words whitespace-normal text-left">
                      {itemAlbum.name}
                    </p>
                  </Button>
                ))}
              </>
            ) : null}
          </div>
        )}
      </div>
    </div>
  );
}
