import Image from "next/image";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";
import {
  Card,
  CardContent,
  CardDescription,
  CardHeader,
  CardTitle,
} from "@/components/ui/card";
import { Label } from "@/components/ui/label";
import { Button } from "@/components/ui/button";
import { FormOfEntry } from "@/components/organism/formOfEntry";
import Link from "next/link";
import { getImagePath } from "@/lib/getImagePath";

export default function Courses() {
  return (
    <div className="relative w-full h-auto ">
      <div
        className="relative w-full h-full bg-cover pt-32 "
        style={{
          backgroundImage: `url('${getImagePath("/assets/bgInicio.svg")}')`,
        }}
      >
        <div className=" flex max-w-screen-2xl mx-auto w-full items-center justify-between gap-4 p-5 sm:p-10 flex-col">
          <div className="w-full flex flex-col items-center justify-center md:items-center md:justify-center">
            <TitleSectionCourses title="Itacoatiara" color="white" />

            <p className="text-white text-justify md:w-[90%]">
              Itacoatiara, localizada na Região do Médio Amazonas, situa-se a
              aproximadamente 170 km em linha reta da capital Manaus e possui
              uma população superior a 90.000 habitantes, configurando-se como o
              terceiro município mais populoso do estado. O município destaca-se
              pela forte produção agropecuária, desenvolvimento da piscicultura
              e pelo setor madeireiro. Além disso, é um importante polo
              cultural, sediando eventos de grande porte, como a ExpoFest onde
              ela é um festival agropecuário que reúne tradição, cultura e o
              melhor da agropecuária do Médio Amazonas e o tradicional Festival
              da Canção de Itacoatiara (FECANI), que atrai visitantes de todo o
              país.
              <br />
              <br />
              Por abranger tanto a zona urbana quanto a zona rural do Estado do
              Amazonas, Itacoatiara desempenha um papel estratégico na logística
              regional, facilitando o escoamento de produtos e pessoas para a
              capital e para os demais sete municípios que integram a Região
              Metropolitana de Manaus. O acesso ao município é realizado tanto
              por vias terrestres quanto por rotas fluviais, consolidando-o como
              um ponto de apoio relevante para a economia e transporte da
              região.
              <br /> <br />
              Devido à sua proximidade com Manaus e ao seu potencial de
              desenvolvimento, Itacoatiara emerge como um local promissor para a
              criação de um centro regional de tecnologia e pesquisa em
              Computação. A carência de soluções tecnológicas voltadas para as
              especificidades locais — como turismo, saúde, cultura, educação e
              comércio — reforça a necessidade de iniciativas na área de
              Tecnologia da Informação (TI), visando promover o crescimento
              socioeconômico do município e da região.
            </p>

            <div className="flex flex-col sm:flex-row items-center justify-center w-full gap-10 mt-9 ">
              <Image
                src={getImagePath("/assets/ita2.png")}
                alt="Imagem ilustrativa"
                width={319}
                height={292}
                className="object-cover w-[80%] sm:w-[230px]"
              />

              <Image
                src={getImagePath("/assets/ita1.png")}
                alt="Imagem ilustrativa"
                width={319}
                height={292}
                className="object-cover w-[80%] sm:w-[230px]"
              />

              <Image
                src={getImagePath("/assets/ita3.png")}
                alt="Imagem ilustrativa"
                width={319}
                height={292}
                className="object-cover w-[80%]  sm:w-[230px]"
              />
            </div>
          </div>

          <div className="w-full flex flex-col items-center justify-center md:items-center md:justify-center mt-20">
            <TitleSectionCourses title="Icet" color="white" />

            <p className="text-white text-justify md:w-[90%]">
              A expansão da Universidade Federal do Amazonas (UFAM) em
              Itacoatiara teve início em 1991, com a instalação do Campus
              Avançado de Itacoatiara, que visava a capacitação de professores
              da rede pública por meio de parcerias entre a Universidade, a
              Prefeitura e o Governo do Estado. Sem prédio próprio, o campus
              utilizava instalações públicas e formou turmas em cursos como
              Pedagogia, Geografia e Matemática.
              <br />
              <br />
              Em 2005, o Campus Universitário Moysés Benarrós Israel foi
              oficialmente criado para atender à demanda educacional de
              Itacoatiara e cidades vizinhas. Um ano depois, a Unidade Acadêmica
              Permanente de Itacoatiara passou a oferecer cursos nas áreas de
              ciências exatas e tecnologia, e, em 2007, foi transformada no
              Instituto de Ciências Exatas e Tecnologia (ICET), com foco em
              formação acadêmica e geração de conhecimento tecnológico.
              <br /> <br />A estrutura do ICET foi ampliada ao longo dos anos.
              Em 2009, novos prédios foram construídos, incluindo blocos para
              salas de aula, laboratórios e biblioteca, expandindo a área
              construída para cerca de 10.807 m². Em 2010, o curso de Engenharia
              de Software foi criado, e em 2012, iniciaram-se os cursos de
              Engenharia Sanitária e Agronomia, além do Programa de
              Pós-graduação em Ciência e Tecnologia para Recursos Amazônicos.
              <br />
              <br />
              Em 2017, foi entregue a Residência Universitária “Josenita de
              Oliveira Alves”, com capacidade para 120 estudantes, construída em
              terreno doado pela Prefeitura de Itacoatiara. Em 2020, um novo
              campus do ICET, com 4.454,56 m² de área construída, foi
              inaugurado, oferecendo mais laboratórios e infraestrutura para
              cursos de graduação e pós-graduação.
              <br />
              <br />
              Hoje, o ICET/UFAM possui mais de 18.000 m² em suas instalações,
              sendo a maior unidade da UFAM no interior do estado, com uma ampla
              oferta de cursos e suporte para atividades de ensino, pesquisa e
              extensão.
            </p>

            <div className="flex flex-col sm:flex-row items-center justify-center w-full gap-10 mt-9 ">
              <Image
                src={getImagePath("/assets/icet1.png")}
                alt="Imagem ilustrativa"
                width={319}
                height={292}
                className="object-cover w-[80%] sm:w-[230px]"
              />

              <Image
                src={getImagePath("/assets/icet2.png")}
                alt="Imagem ilustrativa"
                width={319}
                height={292}
                className="object-cover w-[80%] sm:w-[230px]"
              />

              <Image
                src={getImagePath("/assets/icet3.png")}
                alt="Imagem ilustrativa"
                width={319}
                height={292}
                className="object-cover w-[80%]  sm:w-[230px]"
              />
            </div>
          </div>
        </div>
      </div>

      <div className="flex max-w-screen-2xl mx-auto w-full items-center justify-between gap-4 p-5 sm:p-10 pt-40 flex-col">
        <TitleSectionCourses title="Cursos do Icet" />
        <div
          className="relative w-full bg-cover p-6 rounded-[40px]"
          style={{
            backgroundImage: "url('/assets/bgTextCoures.png')",
          }}
        >
          <p className="text-white text-justify ">
            O campus de Itacoatiara disponibiliza os seguintes cursos de
            graduação: Agronomia, Farmácia, Ciências: Biologia e Química,
            Ciências: Matemática e Física, Engenharia de Produção, Engenharia
            Ambiental e Sanitária, Química Industrial, Pedagogia, Engenharia de
            Software e Sistemas de Informação. Os dois últimos cursos integram a
            área de Computação e serão explorados com mais profundidade.
          </p>
        </div>
        <Image
          src={getImagePath("assets/cursos1.png")}
          alt="Imagem cursos"
          width={319}
          height={292}
          className="object-cover w-[50%]"
        />
        <div
          className="relative w-full bg-cover p-6 rounded-[40px]"
          style={{
            backgroundImage: `url(${getImagePath("/assets/bgTextCoures.png")})`,
          }}
        >
          <p className="text-white text-justify ">
            Para saber mais sobre os cursos disponíveis no ICET, visite a página
            oficial da Instituição. Nela, você encontrará informações detalhadas
            sobre cada curso, incluindo o currículo, o corpo docente, a
            infraestrutura e muito mais. Explore o site para acessar dados
            completos e atualizados sobre as oportunidades educacionais
            oferecidas pelo Instituto.
          </p>
        </div>
        <Button
          asChild
          variant={"secondary"}
          className="bg-blue-700 text-white hover:text-blue-700"
        >
          <Link href="https://www.icet.ufam.edu.br/" target="_blank">
            {" "}
            ICET/UFAM
          </Link>
        </Button>

        <TitleSectionCourses title="Formas de ingresso" />

        <div
          className="relative w-full bg-cover p-6 rounded-[40px]"
          style={{
            backgroundImage: `url(${getImagePath("/assets/bgTextCoures.png")})`,
          }}
        >
          <p className="text-white text-justify ">
            Para ingressar na Universidade Federal do Amazonas (UFAM) os
            interessados podem participar de três opções de processos seletivos:
            Processo Seletivo Contínuo (PSC), Processo Seletivo do Interior
            (PSI) e Sistema de Seleção Unificada (SiSU). Consulte sempre o site
            da Comissão Permanente de Concursos (COMPEC), da UFAM, pois os
            Editais são publicados neste site.
          </p>
        </div>
        <Button
          asChild
          variant={"secondary"}
          className="bg-blue-700 text-white hover:text-blue-700"
        >
          <Link href="https://compec.ufam.edu.br/" target="_blank">
            {" "}
            COMPEC/UFAM
          </Link>
        </Button>

        <div className="flex flex-col gap-4 sm:flex-row">
          <FormOfEntry
            type="PSC"
            text={
              "O Processo Seletivo Contínuo (PSC) é uma forma de ingresso na UFAM, realizada por meio de uma avaliação seriada para alunos das três séries do Ensino Médio. Os pontos são acumulativos, e é necessário renovar a inscrição a cada ano."
            }
          />

          <FormOfEntry
            type="SISU"
            text={
              "No Sistema de Seleção Unificada (Sisu), a seleção segue o edital específico do sistema estabelecido pelo Ministério da Educação (MEC), classificando os candidatos com base nas notas obtidas no Exame Nacional do Ensino Médio (ENEM)."
            }
          />

          <FormOfEntry
            type="PSI"
            text={
              "O Processo Seletivo Interior (PSI) é realizado em formato de vestibular tradicional, com o objetivo de preencher vagas nas unidades da UFAM situadas nos municípios do interior do Amazonas, como Itacoatiara, Parintins, Coari, Benjamin Constant e Humaitá."
            }
          />
        </div>
      </div>

      <div className="flex max-w-screen-2xl mx-auto w-full items-center justify-between gap-4 p-5 sm:p-10 pt-40 flex-col">
        <Tabs defaultValue="course_es" className="w-full">
          <TabsList className="grid w-full grid-cols-2">
            <TabsTrigger value="course_es">Egenharia de Software</TabsTrigger>
            <TabsTrigger value="course_si">Sistemas de Informação</TabsTrigger>
          </TabsList>
          <TabsContent value="course_es">
            <Card>
              <CardHeader>
                <CardDescription>
                  O curso de Bacharelado em Engenharia de Software visa atender
                  a demanda na geração de recurso humano, com habilidade de
                  contribuir para analisar, projetar e desenvolver novas
                  tecnologias de software. E assim permitir o progresso e
                  inovação na produção de ciência e tecnologia. Abaixo, iremos
                  informar alguns dados do curso.
                  <p className="font-semibold mt-2">Função: </p> Planejar e
                  orientar o desenvolvimento de programas, aplicativos e
                  sistemas, garantindo que atendam aos requisitos e desempenhem
                  as funções especificadas. <br />
                  <p className="font-semibold  mt-2">Área: </p>
                  <div className="ml-4">
                    <li>Ciência da Computação</li>
                    <li> Matemática</li>
                    <li>Engenharia de Produção</li>
                  </div>
                  <p className="font-semibold mt-2"> Profissionais: </p>O
                  profissional será responsável por projetar, testar e realizar
                  a manutenção de softwares, sistemas, jogos, aplicativos e
                  plataformas digitais.
                </CardDescription>
              </CardHeader>

              <CardHeader className="">
                <CardTitle className="">Identidade</CardTitle>
              </CardHeader>
              <CardContent className="space-y-2">
                <div className="flex flex-row gap-8 items-center">
                  <CardDescription>
                    Nome: Engenharia de Software <br />
                    Grau: Bacharelado <br />
                    Turno: Diurno <br />
                    Duração: 4,5 anos <br />
                  </CardDescription>
                  <Image
                    src={getImagePath("/assets/Logo-ES.png")}
                    alt="Imagem ilustrativa"
                    width={180}
                    height={292}
                    className="object-cover mb-4"
                  />
                </div>
              </CardContent>

              <CardHeader className="">
                <CardTitle className="">Informações básicas</CardTitle>
              </CardHeader>
              <CardContent className="space-y-2">
                <CardDescription>
                  Número de Vagas Anuais: 50 <br />
                  Turno de Funcionamento: Diurno <br />
                  Integralização do Curso: 4,5 anos <br />
                  Titulação: Bacharel em Engenharia de Software
                  <br />
                  Carga Horária Total: 3.200 horas
                </CardDescription>
              </CardContent>

              <CardHeader className="">
                <CardTitle className="">Formação</CardTitle>
              </CardHeader>
              <CardContent className="space-y-2">
                <div className="flex flex-row justify-center gap-8">
                  <div className="flex items-center flex-col justify-between">
                    <Image
                      src={getImagePath("/assets/CiênciadaComputação.png")}
                      alt="Imagem ilustrativa"
                      width={180}
                      height={292}
                      className="object-cover mb-4"
                    />
                    <Label>Ciência da Computação</Label>
                  </div>
                  <div className="flex items-center flex-col justify-between">
                    <Image
                      src={getImagePath("/assets/Matemática.png")}
                      alt="Imagem ilustrativa"
                      width={180}
                      height={292}
                      className="object-cover mb-4"
                    />
                    <Label>Matemática</Label>
                  </div>
                  <div className="flex items-center flex-col justify-between">
                    <Image
                      src={getImagePath("/assets/EngenhariadeProdução.png")}
                      alt="Imagem ilustrativa"
                      width={180}
                      height={292}
                      className="object-cover mb-4"
                    />
                    <Label>Engenharia de Produção</Label>
                  </div>
                </div>
              </CardContent>

              <CardHeader>
                <CardTitle className="">
                  Benefícios do curso para a sociedade
                </CardTitle>
                <CardDescription>
                  Os produtos de software têm trazido grandes benefícios à
                  sociedade, contribuindo para aumentar tanto a eficiência
                  quanto a produtividade em diversos setores. Esses produtos
                  possibilitam a resolução de problemas de maneira mais eficaz e
                  criam ambientes frequentemente mais seguros, flexíveis e
                  acessíveis. Além disso, promovem inovações que facilitam o
                  cotidiano das pessoas e melhoram a interação entre tecnologia
                  e sociedade, tornando serviços e processos mais rápidos e
                  confiáveis.
                </CardDescription>
              </CardHeader>
            </Card>
          </TabsContent>
          <TabsContent value="course_si">
            <Card>
              <CardHeader>
                <CardDescription>
                  O curso de Bacharelado em Sistemas de Informação visa atender
                  a demanda de profissionais capazes de provocar mudanças
                  através da incorporação de novas tecnologias da informação na
                  solução de problemas organizacionais e sociais, além de serem
                  responsáveis por administrar os sistemas de informação das
                  organizações, planejar e gerenciar a infraestrutura dos bens
                  tecnológicos, bem como desenvolver e evoluir sistemas para uso
                  em processos organizacionais. Abaixo, iremos informar alguns
                  dados do curso.
                  <p className="font-semibold mt-2">Função: </p> Responsável por
                  desenvolver e administrar programas informatizados de
                  armazenamento e compartilhamento de dados. Sua missão consiste
                  em organizar e garantir acesso à informação para todos os
                  departamentos de uma empresa. <br />
                  <p className="font-semibold  mt-2">Área: </p>
                  <div className="ml-4">
                    <li>Ciência da Computação</li>
                    <li> Matemática</li>
                    <li>Administração</li>
                  </div>
                  <p className="font-semibold mt-2"> Profissionais: </p>O O
                  profissional trabalha com a parte administrativa dos sistemas
                  computacionais.
                </CardDescription>
              </CardHeader>

              <CardHeader className="">
                <CardTitle className="">Identidade</CardTitle>
              </CardHeader>
              <CardContent className="space-y-2">
                <div className="flex flex-row gap-8 items-center">
                  <CardDescription>
                    Nome: Sistemas de Informação <br />
                    Grau: Bacharelado <br />
                    Turno: Noturno <br />
                    Duração: 5 anos <br />
                  </CardDescription>
                  <Image
                    src={getImagePath("/assets/logo-SI.png")}
                    alt="Imagem ilustrativa"
                    width={180}
                    height={292}
                    className="object-cover mb-4"
                  />
                </div>
              </CardContent>

              <CardHeader className="">
                <CardTitle className="">Informações básicas</CardTitle>
              </CardHeader>
              <CardContent className="space-y-2">
                <CardDescription>
                  Número de Vagas Anuais: 50 <br />
                  Turno de Funcionamento: Noturno <br />
                  Integralização do Curso: 5 anos <br />
                  Titulação: Bacharel em Sistemas de Informação
                  <br />
                  Carga Horária Total: 3.200 horas
                </CardDescription>
              </CardContent>

              <CardHeader className="">
                <CardTitle className="">Formação</CardTitle>
              </CardHeader>
              <CardContent className="space-y-2">
                <div className="flex flex-row justify-center gap-8">
                  <div className="flex items-center flex-col justify-between">
                    <Image
                      src={getImagePath("/assets/CiênciadaComputação.png")}
                      alt="Imagem ilustrativa"
                      width={180}
                      height={292}
                      className="object-cover mb-4"
                    />
                    <Label>Ciência da Computação</Label>
                  </div>
                  <div className="flex items-center flex-col justify-between">
                    <Image
                      src={getImagePath("/assets/Matemática.png")}
                      alt="Imagem ilustrativa"
                      width={180}
                      height={292}
                      className="object-cover mb-4"
                    />
                    <Label>Matemática</Label>
                  </div>
                  <div className="flex items-center flex-col justify-between">
                    <Image
                      src={getImagePath("/assets/Administração.png")}
                      alt="Imagem ilustrativa"
                      width={180}
                      height={292}
                      className="object-cover mb-4"
                    />
                    <Label>Administração</Label>
                  </div>
                </div>
              </CardContent>
              <CardHeader>
                <CardTitle> Benefícios do curso para a sociedade</CardTitle>
                <CardDescription>
                  A aplicação dos Sistemas de Informação e das Tecnologias da
                  Informação e Comunicação (TIC) nas organizações traz
                  significativos benefícios para a sociedade, promovendo maior
                  eficiência no uso de recursos. Esses sistemas impactam
                  diretamente a produtividade e a competitividade, tanto das
                  empresas quanto do país como um todo, o que é essencial em um
                  cenário cada vez mais globalizado e competitivo. Além disso,
                  contribuem para a inovação, facilitam a tomada de decisões e
                  possibilitam o desenvolvimento de soluções tecnológicas que
                  atendem às necessidades da população em diversos setores, como
                  saúde, educação e serviços públicos.
                </CardDescription>
              </CardHeader>
            </Card>
          </TabsContent>
        </Tabs>
      </div>
    </div>
  );
}

function TitleSectionCourses({
  title,
  color = "dark",
}: {
  title: string;
  color?: "white" | "dark";
}) {
  const textColor = color === "white" ? "text-white" : "text-black";

  return (
    <h1
      className={`relative text-3xl font-bold ${textColor} w-full z-10 mb-2 mt-10 text-center`}
    >
      {title}
    </h1>
  );
}
