/** @type {import('next').NextConfig} */

const isProd = process.env.NODE_ENV === "production";

const nextConfig = {
  basePath: isProd ? "/logarteste" : "",
  assetPrefix: isProd ? "/logarteste/" : "",
  images: {
    remotePatterns: [
      {
        protocol: "http",
        hostname: "servicosweb.cnpq.br",
      },
      {
        protocol: "https",
        hostname: "servicosweb.cnpq.br",
      },
      {
        protocol: "https",
        hostname: "drive.google.com",
      },
      {
        protocol: "https",
        hostname: "drive.usercontent.google.com",
      },
      {
        protocol: "https",
        hostname: "encrypted-tbn0.gstatic.com",
      },
    ],
  },
  env: {
    NEXT_PUBLIC_BASE_PATH: isProd ? "/logarteste" : "",
  },
};

export default nextConfig;
